#! /usr/bin/python
# -*- coding:utf-8 -*-

############################################################################
###########          CODE SIMULANT L'OSCILLATEUR DE CHUA          ##########
###########        DÉVELOPPÉ POUR LE TIPE PRÉVISION (2012)        ##########
############################################################################
###########                 UPDATE DU 11/02/2018                  ##########
###########        CODE POUR PYTHON 2 ### MANGEAT MATTHIEU        ##########
############################################################################

import numpy as np
import matplotlib
import matplotlib.pyplot as plt
import sys

plt.rc('font', family='serif')
plt.rc('text', usetex=True)	

##############################
#### PARAMETRES PHYSIQUES ####
##############################

R1=-1200.;R4=3300.;R5=47000.;L=1.8e-3;C1=1e-9;C2=15e-9;R=1.7e3 ##SI
tmax=3e2;dt=1e-4
	
for arg in sys.argv[1:]:
	if '-dt=' in arg:
		dt=float(arg[4:])
	elif '-tmax=' in arg:
		tmax=float(arg[6:])
	elif '-R=' in arg:
		R=float(arg[3:]) ### Remarque : R>1656
	else:
		print "Mauvais argument :", arg
		sys.exit(0)

##################################
#### PARAMETRES ADIMENSIONNÉS ####
##################################

alpha1,alpha2,alpha3=C2/C1,1,-C2*R**2/L
g1,g2=R*(1/R1+1/R4+1/R5),-0.5*R*(1/R4+1/R5)
print alpha1,alpha2,alpha3,g1,g2

#############################################
#### RÉSOLUTION DES ÉQUATIONS ORDINAIRES ####
####            dX/dt = F(X)             ####
#############################################

def g(x):
	global g1,g2
	return g1*x+g2*(abs(x+1)-abs(x-1))
	
def F1(x1,x2,x3):
	global alpha1
	return alpha1*(x2-x1-g(x1))

def F2(x1,x2,x3):
	global alpha2
	return alpha2*(x1-x2+x3)
	
def F3(x1,x2,x3):
	global alpha3
	return alpha3*x2
	
def Chua_Euler(x1,x2,x3,dt,tmax):
	""" Résolution des équations "Chua" par la méthode d'Euler"""
	t=0
	while t<tmax:
		x1.append(x1[-1]+F1(x1[-1],x2[-1],x3[-1])*dt)
		x2.append(x2[-1]+F2(x1[-1],x2[-1],x3[-1])*dt)
		x3.append(x3[-1]+F3(x1[-1],x2[-1],x3[-1])*dt)		
		t+=dt
		
	return np.array(x1),np.array(x2),np.array(x3)

def Chua_RK4(x1,x2,x3,dt,tmax):
	""" Résolution des équations "Chua" par la méthode Runge-Kutta 4"""
	t=0	
	while t<tmax:
		k1=F1(x1[-1],x2[-1],x3[-1])
		l1=F2(x1[-1],x2[-1],x3[-1])
		m1=F3(x1[-1],x2[-1],x3[-1])
		
		k2=F1(x1[-1]+k1*dt/2.,x2[-1]+l1*dt/2.,x3[-1]+m1*dt/2.)
		l2=F2(x1[-1]+k1*dt/2.,x2[-1]+l1*dt/2.,x3[-1]+m1*dt/2.)
		m2=F3(x1[-1]+k1*dt/2.,x2[-1]+l1*dt/2.,x3[-1]+m1*dt/2.)
		
		k3=F1(x1[-1]+k2*dt/2.,x2[-1]+l2*dt/2.,x3[-1]+m2*dt/2.)
		l3=F2(x1[-1]+k2*dt/2.,x2[-1]+l2*dt/2.,x3[-1]+m2*dt/2.)
		m3=F3(x1[-1]+k2*dt/2.,x2[-1]+l2*dt/2.,x3[-1]+m2*dt/2.)
		
		k4=F1(x1[-1]+k3*dt,x2[-1]+l3*dt,x3[-1]+m3*dt)
		l4=F2(x1[-1]+k3*dt,x2[-1]+l3*dt,x3[-1]+m3*dt)
		m4=F3(x1[-1]+k3*dt,x2[-1]+l3*dt,x3[-1]+m3*dt)
		
		x1.append(x1[-1]+(k1+2*k2+2*k3+k4)*dt/6.)
		x2.append(x2[-1]+(l1+2*l2+2*l3+l4)*dt/6.)
		x3.append(x3[-1]+(m1+2*m2+2*m3+m4)*dt/6.)		
		t+=dt
		
	return np.array(x1),np.array(x2),np.array(x3)

t=np.linspace(0,tmax,int(tmax/dt+2))
N=10 ## Contrôle le nombre de points à afficher
tma=100 ## Temps maximum à afficher

x1,x2,x3=Chua_RK4([1],[1],[0],dt,tmax)
x1b,x2b,x3b=Chua_RK4([1.01],[1.01],[0.],dt,tmax)

###############################
#### FIGURE 1 - ATTRACTEUR ####
###############################

plt.figure(figsize=(8,6))
plt.rc("font",size=20)
gs=matplotlib.gridspec.GridSpec(1,1,width_ratios=[1],height_ratios=[1],left=0.12,right=0.97,bottom=0.1,top=0.97)

plt.subplot(gs[0,0])
plt.plot(x1[::N],x2[::N],'k')
plt.xlabel('$x_1$')
plt.ylabel('$x_2$')
plt.savefig('phase_xy_RK4.pdf',quality=100)
#plt.savefig('phase_xy_RK4.svg',quality=100)
plt.close()

#########################################################
#### FIGURE 2 - SENSIBILITÉ AUX CONDITIONS INITIALES ####
#########################################################

plt.figure(figsize=(28,6))
plt.rc("font",size=30)
gs=matplotlib.gridspec.GridSpec(1,3,width_ratios=[1,1,1],height_ratios=[1],left=0.05,right=0.99,bottom=0.15,top=0.96,wspace=0.25,hspace=0.25)

plt.subplot(gs[0,0])
plt.plot(t[::N][t[::N]<tma],x1[::N][t[::N]<tma],'k',lw=1.5)
plt.plot(t[::N][t[::N]<tma],x1b[::N][t[::N]<tma],'r',lw=1.5)
plt.xlabel('$t$')
plt.ylabel('$x_1$')

plt.subplot(gs[0,1])
plt.plot(t[::N][t[::N]<tma],x2[::N][t[::N]<tma],'k',lw=1.5)
plt.plot(t[::N][t[::N]<tma],x2b[::N][t[::N]<tma],'r',lw=1.5)
plt.xlabel('$t$')
plt.ylabel('$x_2$')

plt.subplot(gs[0,2])
plt.plot(t[::N][t[::N]<tma],x3[::N][t[::N]<tma],'k',lw=1.5)
plt.plot(t[::N][t[::N]<tma],x3b[::N][t[::N]<tma],'r',lw=1.5)
plt.xlabel('$t$')
plt.ylabel('$x_3$')

plt.savefig('sensibilite_init_RK4.pdf',quality=100)
#plt.savefig('sensibilite_init_RK4.svg',quality=100)
plt.close()
